<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Toastify CSS -->
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">

  <!-- Toastify JS -->
  <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
</head>
<style>
  .error-msg {
    color: red;
    font-size: 13px;
  }

  .required {
    color: red;
  }
</style>

<body>
  <?php include("./includes/header.php") ?>

<div class="sub-banner">
        <div class="overlay"></div>
        <div class="sub-banner-content text-center">
            <h1 class="title">Contact Us</h1>
            <nav class="breadcrumb">
                <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Contact Us</span>
            </nav>
        </div>
    </div>

  <main id="main">
    <section class="contact-us01 section-padding">
      <div class="container">
        <div class="row mb-5 justify-content-center">

          <div class="col-md-6 col-lg-4">
            <div class="cont-cont d-flex flex-column align-items-center">
              <h4 class="d-flex flex-column align-items-center"> <i class="bi bi-geo-alt-fill"></i> reach us</h4>
              <p>
                <a href="#!">
                  Thaw Designer - SF NO. 128/2, <br>
                  Ground Floor, Chandra Garden Road, <br>
                  behind Aalam Montessori school,<br>
                  Thriveni West Road, Kalapatti,<br>
                  Coimbatore, Tamil Nadu 641035.
                </a>
              </p>
            </div>
          </div>
          <div class="col-md-6 col-lg-4">
            <div class="cont-cont d-flex flex-column align-items-center">
              <h4 class="d-flex flex-column align-items-center"> <i class="bi bi-telephone-fill"></i> call us</h4>
              <p>

                <a href="tel:+9190956 59705"><i class="bi bi-telephone-fill"></i> +91 90956 59705 </a>
              </p>
              <p>

                <a href="tel:+919384998646"><i class="bi bi-telephone-fill"></i> +91 93849 98646 </a>
              </p>
              </p>
            </div>
          </div>
          <div class="col-md-6 col-lg-4">
            <div class="cont-cont d-flex flex-column align-items-center">
              <h4 class="d-flex flex-column align-items-center"> <i class="bi bi-envelope-fill"></i> email support</h4>
              <p>
                <a href="mailto:enquiry@thawdesigners.in"><i class="bi bi-envelope-fill"></i> enquiry@thawdesigners.in </a>
              </p>
            </div>
          </div>

        </div>
        <!-- 2 -->
        <div class="row">
          <div class="col-lg-6 col-md-6 mb-5">
            <div class="con-form" id="enquire-now">
              <h4>enquire now</h4>
              <form action="contact.php" method="POST" id="contact-main">
                <div class="row">
                  <div class="col-md-6">
                    <label>Name<span class="required">*</span></label>
                    <input type="text" class="form-control" placeholder="Name *" name="name" id="name">
                    <div class="error-msg text-danger" id="name-error"></div>
                  </div>

                  <div class="col-md-6">
                    <label>Email Id<span class="required">*</span></label>
                    <input type="email" class="form-control" placeholder="Email Id *" name="email" id="email">
                    <div class="error-msg text-danger" id="email-error"></div>
                  </div>

                  <div class="col-md-6">
                    <label>Mobile Number<span class="required">*</span></label>
                    <input type="text" class="form-control" placeholder="Mobile Number *" name="mobile" id="mobile">
                    <div class="error-msg text-danger" id="mobile-error"></div>
                  </div>

                  <div class="col-md-6">
                    <label>Subject</label>
                    <input type="text" class="form-control" placeholder="Subject *" name="subject" id="subject">
                    <div class="error-msg text-danger" id="subject-error"></div>
                  </div>

                  <div class="col-md-12">
                    <label>Message<span class="required">*</span></label>
                    <textarea class="form-control" placeholder="Message *" name="message" rows="5" id="message"></textarea>
                    <div class="error-msg text-danger" id="message-error"></div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-lg-12 col-md-12">
                    <div class="text-center mt-3">
                      <button class="btn btn-primary" type="submit"><i class="bi bi-envelope-fill"></i> Submit</button>
                    </div>
                  </div>
                </div>
              </form>

            </div>
          </div>
          <div class="col-lg-6 col-md-6 mb-5">
            <div class="map-sec">
              <iframe src="https://www.google.com/maps/embed?pb=!1m23!1m12!1m3!1d141280.42425182567!2d76.94988381160259!3d11.084073020850166!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!4m8!3e6!4m0!4m5!1s0x3ba8f977ad684c51%3A0x60b9bf70d701fc83!2sSF%20NO.%20128%2F2%2C%20Chandra%20Garden%2C%20Road%2C%20behind%20Aalam%20Montessori%20school%2C%20Thriveni%20West%2C%20Kalapatti%2C%20Coimbatore%2C%20Tamil%20Nadu%20641035!3m2!1d11.0840842!2d77.0322857!5e1!3m2!1sen!2sin!4v1754473771352!5m2!1sen!2sin" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
              </div>
          </div>
        </div>
      </div>
      <script>
        document.getElementById('contact-main').addEventListener('submit', function(event) {
          event.preventDefault();
          document.querySelectorAll('.error-message').forEach(element => {
            element.textContent = '';
          });

          let isValid = true;
          const name = document.getElementById('name').value.trim();
          const email = document.getElementById('email').value.trim();
          const phone = document.getElementById('mobile').value.trim();
          const message = document.getElementById('message').value.trim();

          if (name === '') {
            document.getElementById('name-error').textContent = 'Name is required';
            isValid = false;
          }
          if (email === '') {
            document.getElementById('email-error').textContent = 'Email is required';
            isValid = false;
          } else if (!validateEmail(email)) {
            document.getElementById('email-error').textContent = 'Invalid email format';
            isValid = false;
          }
          if (mobile === '') {
            document.getElementById('mobile-error').textContent = 'Phone number is required';
            isValid = false;
          }
          if (message === '') {
            document.getElementById('message-error').textContent = 'Message is required';
            isValid = false;
          }

          console.log(isValid);
          if (isValid) {
            const formData = new FormData(document.getElementById('contact-main'));
            fetch('contact.php', {
                method: 'POST',
                body: formData,
              })
              .then(response => response.json())
              .then(data => {
                Toastify({
                  text: data.message,
                  duration: 3000,
                  close: true,
                  gravity: 'top',
                  position: 'right',
                  backgroundColor: data.status === 'success' ? 'green' : 'red',
                }).showToast();
                console.log(data);
                
                  document.getElementById('contact-main').reset();
                
              })
              .catch(() => {
                Toastify({
                  text: 'An error occurred while submitting the form. Please try again later.',
                  duration: 3000,
                  close: true,
                  gravity: 'top',
                  position: 'right',
                  backgroundColor: 'red',
                }).showToast();
              });
          }
        });

        function validateEmail(email) {
          const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
          return re.test(email.toLowerCase());
        }



        document.getElementById('mobile').addEventListener('input', function() {
          this.value = this.value.replace(/[^0-9]/g, '');
        });
      </script>
    </section>



  </main>

  <?php include("./includes/footer.php") ?>
  <?php include("./includes/script.php") ?>
</body>

</html>