<!DOCTYPE html>
<html lang="en">

<body>
     <?php include("./includes/header.php") ?>

     <div class="sub-banner">
          <div class="overlay"></div>
          <div class="sub-banner-content text-center">
               <h1 class="title">Job Work</h1>
               <nav class="breadcrumb">
                    <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Job Work</span>
               </nav>
          </div>
     </div>
     <main id="main">

          <!-- Architecture L Kitchen -->
          <section class="kitchen-island-section">
               <div class="container">
                    <!-- 1 -->
                    <div class="row">

                         <!-- Text Content -->
                         <div class="col-lg-6 order-2 order-lg-1">
                              <div class="kitchen-island-text pe-lg-4">
                                   <h3 class="fw-bold text-uppercase" style="background-color: #c8b16f; color: #fff; display: inline-block; padding: 5px 10px;">Four Walls Interiors and Beyond</h3>
                                   <p class="mt-3">
                                        At Four Walls Interiors and Beyond, we believe great interiors are not just built, they are crafted with care, precision, and passion. We are your trusted partner for complete interior job work solutions – from cutting board, mica pressing, and edge banding to the finest detailing that brings your design vision to life.
                                   </p>
                                   <p class="mt-3">
                                        With a focus on end-to-end execution, our expertise ensures every project runs smoothly, efficiently, and with uncompromising quality. Whether you are a designer, contractor, or homeowner, we provide the technical backbone that transforms concepts into stunning, ready-to-use interiors.
                                   </p>
                                   <p class="mt-3">
                                        Our end-to-end job work services ensure smooth execution, timely delivery, and top-notch quality. Whether for designers, contractors, or homeowners, we are the trusted backbone behind interiors that are functional, stylish, and built to last.

                                   <div class="progress-container">
                                        <div class="d-flex justify-content-between">
                                             <div class="progress-title">Board Cutting</div>
                                             <div class="progress-value" id="arch-percent">0%</div>
                                        </div>
                                        <div class="progress">
                                             <div class="progress-bar" role="progressbar" id="arch-bar" style="width: 0%"></div>
                                        </div>
                                   </div>

                                   <div class="progress-container">
                                        <div class="d-flex justify-content-between">
                                             <div class="progress-title">Mica Pressing </div>
                                             <div class="progress-value" id="interior-percent">0%</div>
                                        </div>
                                        <div class="progress">
                                             <div class="progress-bar" role="progressbar" id="interior-bar" style="width: 0%"></div>
                                        </div>
                                   </div>
                                   <div class="progress-container">
                                        <div class="d-flex justify-content-between">
                                             <div class="progress-title">Edge Branding </div>
                                             <div class="progress-value" id="interior-percents">0%</div>
                                        </div>
                                        <div class="progress">
                                             <div class="progress-bar" role="progressbars" id="interior-bars" style="width: 0%"></div>
                                        </div>
                                   </div>
                                   <br>
                                   <div>
                                        <a href="contact-us.php" class="custom-btn hvr-sweep-to-right">
                                             Enquiry Now <i class="bi bi-arrow-right"></i>
                                        </a>
                                   </div>

                              </div>
                         </div>

                         <!-- Image Content -->
                         <div class="col-lg-6 order-1 order-lg-2  mb-lg-0">
                              <div class="row  mb-5">
                                   <div class="col-12">

                                        <div>
                                             <img class="img-fluid job-work-img" src="./assets/img/jobwork.jpg" alt="" srcset="">
                                        </div>


                                   </div>
                              </div>
                         </div>

                    </div>

               </div>
          </section>
          <section class="section-padding features-bg">
               <div class="container-fluid">
                    <div class="text-center jobwork-sec mb-5">
                         <h2 class="clr-head"> <span class="bold-span">o</span>ur <span class="color-span"><span class="bold-span">j</span>ob Work</span> </h2>

                         <p class="para-ser text-center">
                              Complete interior job work solutions crafted with care, precision, and passion.
                         </p>
                    </div>
                    <div class="row text-center justify-content-center">

                         <!-- Cutting Board with Precision -->
                         <div class="col-lg-3  col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-scissors" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Cutting Board with Precision</div>
                              <div class="design-description">
                                   Clean, accurate cuts for flawless finishes that bring out the best in your interiors.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>

                         <!-- Mica Pressing -->
                         <div class="col-lg-3 col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-layers-fill" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Mica Pressing</div>
                              <div class="design-description">
                                   Seamless mica pressing for durability, strength, and a perfect look every time.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>

                         <!-- Edge Banding -->
                         <div class="col-lg-3 col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-border-style" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Edge Banding</div>
                              <div class="design-description">
                                   Smooth, professional edges that elevate the overall appeal of your furniture and interiors.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>

                         <!-- Custom Interior Job Work -->
                         <div class="col-lg-3 col-md-6 col-sm-6 col-12 design-service-box unique-box-1 wow animate__animated animate__fadeInUp" data-wow-delay="0.3s">
                              <div class="design-icon">
                                   <i class="bi bi-house-heart-fill" style="font-size: 48px;"></i>
                              </div>
                              <div class="design-title">Custom Interior Job Work</div>
                              <div class="design-description">
                                   Tailored interior solutions designed to match your unique style and requirements.
                              </div>
                              <div class="design-underline">
                                   <div class="design-underline-line"></div>
                                   <div class="design-underline-dot"></div>
                                   <div class="design-underline-line"></div>
                              </div>
                         </div>

                    </div>
               </div>
          </section>


          <!-- End Architecture L Kitchen -->
     </main>

     <?php include("./includes/footer.php") ?>
     <?php include("./includes/script.php") ?>

  <script>
    function animateProgressBar(id, percentId, target) {
      let i = 0;
      const bar = document.getElementById(id);
      const percentText = document.getElementById(percentId);
      const interval = setInterval(() => {
        if (i >= target) clearInterval(interval);
        else {
          i++;
          bar.style.width = i + '%';
          percentText.textContent = i + '%';
        }
      }, 20);
    }

    // Animate on load
    window.onload = () => {
      animateProgressBar('arch-bar', 'arch-percent', 95);
      animateProgressBar('interior-bar', 'interior-percent', 90);
      animateProgressBar('interior-bars', 'interior-percents', 90);
    };
  </script>

</body>

</html>