<!DOCTYPE html>
<html lang="en">

<body>
  <?php include("./includes/header.php") ?>

 <div class="sub-banner">
        <div class="overlay"></div>
        <div class="sub-banner-content text-center">
            <h1 class="title">Architecture </h1>
            <nav class="breadcrumb">
                <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Architecture </span>
            </nav>
        </div>
    </div>
  <main id="main">

    <section class="projects01 ">
      <div class="container">
        <h1>Architecture </h1>
        <!-- Tab Links -->
        <div class="row">
          <div class="col-12">
            <div>
              <ul class="project-filter list-inline text-center mb-4">
                <li class="list-inline-item active" data-filter="all">All</li>
                <li class="list-inline-item" data-filter="residence">Residence</li>
                <li class="list-inline-item" data-filter="apartment">Apartment</li>
                <li class="list-inline-item" data-filter="commercial">Commercial</li>
                <li class="list-inline-item" data-filter="school">School</li>
                <li class="list-inline-item" data-filter="hospital">Hospital</li>
              </ul>

            </div>
          </div>
        </div>

        <div class="row" id="dynamicGallery"></div>

      </div>
    </section>




  </main>
  <?php include("./includes/footer.php") ?>
  <?php include("./includes/script.php") ?>






</body>
<script>
const imageData = [
  {
    filename: "imgi_3_VELLALORE NEST.png",
    title: "Aasrutha Apartments, Saravanampatty",
    alt: "Aasrutha Apartments, Saravanampatty",
    para:"Aasrutha Apartments in Saravanampatty is a modern residential project offering elegant design, comfort, and excellent connectivity in Coimbatore’s growing IT hub.",
    category: "apartment"
  },
  {
    filename: "imgi_4_2.png",
    title: "CMC School, Auditorium",
    alt: "CMC School, Auditorium",
    para:"Designed for functional acoustics and elegant aesthetics, the CMC School Auditorium creates a vibrant space for student gatherings and performances",
    category: "school"
  },

  {
    filename: "imgi_6_16.png",
    title: "Dejoo Residence, Sundarapalayam",
    alt: "Dejoo Residence, Sundarapalayam",
    para:"This residence blends contemporary styling with traditional warmth, offering elegant comfort and privacy in Sundarapalayam’s serene setting.",
    category: "residence"
  },
  {
    filename: "imgi_7_COVER 2.png",
    title: "Dr. Krishna Colony, Apartment",
    alt: "Dr. Krishna Colony, Apartment",
    para:"A modern apartment design that maximizes light, space, and urban comfort in the heart of Dr. Krishna Colony, Coimbatore.",
    category: "apartment"
  },
  {
    filename: "imgi_8_WhatsApp Image 2022-11-06 at 3.47.27 PM (1).png",
    title: "Entrance Arch, KG, Kovilpalayam",
    alt: "Entrance Arch, KG, Kovilpalayam",
    para:"A grand and welcoming archway at KG School, Kovilpalayam, combining traditional form with modern construction techniques.",
    category: "school"
  },
  {
    filename: "imgi_9_6_11 - Photo.png",
    title: "Everest Elegance",
    alt: "Everest Elegance",
    para:"Everest Elegance showcases luxury living with bold architecture, premium finishes, and carefully planned interiors in a high-end Kalapatti community.",
    category: "apartment"
  },
  {
    filename: "imgi_10_13 (1).png",
    title: "Dr. Kaja Residence, Podanur",
    alt: "Dr. Kaja Residence, Podanur",
    para:"Designed for spacious living with elegant interiors, Dr. Kaja Residence blends modern comfort with thoughtful architecture in the peaceful locality of Podanur.",
    category: "residence"
  },

  {
    filename: "imgi_11_IMG-20180423-WA0042.png",
    title: "Fathima Hospital, Podanur",
    alt: "Fathima Hospital, Podanur",
    category: "hospital",
    para:"A well-planned hospital space with a patient-centric design, Fathima Hospital offers modern medical facilities in a clean, efficient, and healing-focused environment.",
  },
  {
    filename: "imgi_12_Muthu Hospital-Exterior View-1-26-12-17-Option-4.png",
    title: "Muthu Hospital, Trichy Road",
    alt: "Hospital exterior elevation",
    para:"Muthu Hospital features a clean, modern façade with efficient layout planning, designed to support both outpatient and emergency services with architectural clarity.",
    category: "hospital"
  },
  {
    filename: "imgi_13_12TD_NewRoyalOrchidApartmentPRINT.png",
    title: "Royal Orchid Apartment",
    alt: "Royal Orchid front view",
    para:"Royal Orchid Apartment offers refined urban living with elegant architecture, quality craftsmanship, and modern comforts, nestled in a serene and well-connected Kalapatti neighborhood.",
    category: "apartment"
  },
  {
    filename: "imgi_14_AMBALAVANAN.png",
    title: "Ambalavanan, Saravanampatty",
    alt: "Ambalavanan, Saravanampatty",
    para:"A thoughtfully designed clinical space combining functional planning and patient comfort in the vibrant community of Saravanampatty.",
    category: "hospital"
  },
  // {
  //   filename: "imgi_15_21.png",
  //   title: "Project 15.21",
  //   alt: "Modern staircase perspective",
  //   category: "residence"
  // },
  {
    filename: "imgi_16_6 (2).png",
    title: "Residence, Ganapathy",
    alt: "Residence, Ganapathy",
    para:"A stylish and compact home that combines everyday functionality with creative interior elements in the Ganapathy area.",
    category: "residence"
  },
  {
    filename: "imgi_17_31_2 - Photo.png",
    title: "Sabarish Residence",
    alt: "Sabarish Residence",
    para:"Sabarish Residence is a bespoke home that blends modern aesthetics with personal comfort, featuring elegant interiors and a serene atmosphere in the heart of Kalapatti’s residential enclave.",
    category: "residence"
  },
  {
    filename: "imgi_18_9_8.png",
    title: "Subbaiah School",
    alt: "Subbaiah School",
    para:"An institutionally planned school layout with a focus on open learning environments and strong architectural identity.",
    category: "school"
  },
  {
    filename: "imgi_19_Mahanadi Residency_G+1_Cr 2.png",
    title: "Mahanadi Residency",
    alt: "Front elevation of G+1",
    para:"Mahanadi Residency combines functional design with contemporary aesthetics, offering well-planned homes, essential amenities, and a tranquil environment in the fast-growing Coimbatore locality.",
    category: "residence"
  },
  {
    filename: "imgi_20_Visrutha.png",
    title: "Visrutha, Gandhipuram",
    alt: "Visrutha, Gandhipuram",
    para:"Located in Gandhipuram, Visrutha is a multi-functional space featuring refined commercial architecture with sleek lines and modern visual balance.",
    category: "commercial"
  },
  {
    filename: "imgi_21_VIVANTH.png",
    title: "Vivanth Residency",
    alt: "Contemporary apartment block",
    para:"Vivanth Residency exemplifies modern lifestyle with smartly designed interiors, superior finishes, and a peaceful ambiance, set within the vibrant surroundings of Coimbatore.",
    category: "residence"
  },
  {
    filename: "imgi_22_01.png",
    title: "Navarathna, R.S Puram",
    alt: "Navarathna, R.S Puram",
    para:"Navarathna, R.S. Puram reflects premium city living with elegant architecture, upscale finishes, and thoughtfully planned interiors, set in one of Coimbatore’s most prestigious and well-connected neighborhoods.",
    category: "residence"
  },
  {
    filename: "imgi_24_18THAW_AashruthaPRINT.png",
    title: "Aashrutha Project",
    alt: "Institutional block rendering",
    para:"Aashrutha Project offers thoughtfully crafted living spaces with a focus on comfort, simplicity, and everyday convenience, located in a peaceful and well-connected part of coimbatore.",
    category: "apartment"
  },
  {
    filename: "imgi_25_06TD_NavarathanaPRINT.png",
    title: "Navarathana Apartments",
    alt: "Gated community layout",
    para:"Navarathana Apartments blends contemporary design with comfort, offering sophisticated living spaces, top-tier amenities, and thoughtful layouts in the heart of Kalapatti’s thriving residential zone.",
    category: "apartment"
  },
    {
    filename: "biggstore.png",
    title: "Commercial Complex, Davangere",
    alt: "Commercial Complex, Davangere",
    para:"A multi-utility commercial complex designed for functionality, retail flow, and aesthetic appeal in the bustling city of Davangere.",
    category: "commercial"
  }


];


  const container = document.getElementById("dynamicGallery");

 imageData.forEach(({ filename, title, alt, category,para }) => {
  const colDiv = document.createElement("div");
  colDiv.className = `col-lg-4 col-md-6 mb-4 gallery-item ${category}`;

  colDiv.innerHTML = `
    <div class="image-box position-relative overflow-hidden">
      <a href="./assets/img/projects/architecture/${filename}" class="glightbox" data-gallery="gallery1" data-title="${title}">
        <img class="img-fluid" src="./assets/img/projects/architecture/${filename}" alt="${alt}" loading="lazy">
        <div class="overlay-icon">
          <i class="bi bi-eye"></i>
        </div>
      </a>
      <p class="image-caption-h2 text-center mt-2">${title}</p>
      <p class="image-caption text-center mt-2">${para}</p>
    </div>
  `;

  container.appendChild(colDiv);
});

  const lightbox = GLightbox({
    selector: '.glightbox',
    touchNavigation: true,
    loop: true,
    zoomable: false
  });
</script>

<script>
  const filterButtons = document.querySelectorAll('.project-filter li');

  filterButtons.forEach(btn => {
    btn.addEventListener('click', () => {
      const filter = btn.getAttribute('data-filter');

      // Update active class
      filterButtons.forEach(b => b.classList.remove('active'));
      btn.classList.add('active');

      // Filter images
      document.querySelectorAll('.gallery-item').forEach(item => {
        if (filter === 'all' || item.classList.contains(filter)) {
          item.style.display = "block";
        } else {
          item.style.display = "none";
        }
      });
    });
  });
</script>

</html>