<!DOCTYPE html>
<html lang="en">

<body>
  <?php include("./includes/header.php") ?>

  <!-- Sub Banner Section -->
  <div class="sub-banner">
    <div class="overlay"></div>
    <div class="sub-banner-content text-center">
      <h1 class="title">Interior</h1>
      <nav class="breadcrumb">
        <a href="index.php">Home</a> &nbsp; / &nbsp; <span>Interior</span>
      </nav>
    </div>
  </div>

  <main id="main">

    <section class="projects01 ">
      <div class="container">
        <h1>Interior</h1>
        <!-- Tab Links -->
        <div class="row">
          <div class="col-12">
            <div>
              <ul class="project-filter list-inline text-center mb-4">
                <li class="list-inline-item active" data-filter="all">All</li>
                <li class="list-inline-item" data-filter="residence">Residence</li>
                <li class="list-inline-item" data-filter="apartment">Apartment</li>
                <li class="list-inline-item" data-filter="commercial">Commercial</li>
                <li class="list-inline-item" data-filter="school">School</li>
              </ul>

            </div>
          </div>
        </div>

        <div class="row" id="dynamicGallery"></div>

      </div>
    </section>




  </main>
  <?php include("./includes/footer.php") ?>
  <?php include("./includes/script.php") ?>






</body>
<script>
  const imageData = [{
      filename: "img (1).webp",
      title: "Proposed interiors at Periyanaickem Palayam",
      alt: "Proposed interiors at Periyanaickem Palayam",
      para: "Mani’s Residency Proposed Interiors...",
      category: "residence",
      folder: "residence/proposed",
      multiimages: [
        "img (1).webp",
        "img (2).webp",
        "img (3).webp",
        "img (4).webp",
        "img (5).webp",
        "img (6).webp",
        "img (7).webp",
        "img (8).webp"
      ]
    }, {
      filename: "img (2).webp",
      title: "Taisha Park - Chennai",
      alt: "Taisha Park - Chennai",
      para: "HIG Project offers luxury apartment interior design with elegant and functional layouts, spacious living areas, premium finishes, and modern amenities for upscale urban living",
      category: "residence",
      folder: "apartment/taisha park",
      multiimages: [
        "img (2).webp",
        "img (1).webp",
        "img (3).webp",
        "img (4).webp",
        "img (5).webp",
        "img (6).webp",
        "img (7).webp",
        "img (8).webp",
        "img (9).webp",
        "img (10).webp",
      ]
    },

    {
      filename: "bed_1_4.webp",
      title: "Icon City Velankuruchi",
      alt: "Icon City Velankuruchi",
      para: "Icon City Velankuruchi blends contemporary residential interiors with lush surroundings, spacious homes, premium amenities, and a vibrant community for elegant urban living.",
      category: "apartment",
      folder: "apartment/icon-city",
      multiimages: [
        "bed_1_4.webp",
        "bed_2_3.webp",
        "dining_2.webp",
        "dining_3.webp",
        "kit_corner_1_4.webp",
        "kit_wall_1_2.webp",
        "living_1.webp",
        "living_2.webp",
        "pooja_1.webp",
        "pooja_2.webp"
      ]
    },

    {
      filename: "img (1).webp",
      title: "IMR Office, Salem",
      alt: "IMR Office, Salem",
      para: "IMR Office in Salem features premium office interior design concepts, offering contemporary workspace layouts designed to enhance productivity with elegant and functional interiors.",
      category: "commercial",
      folder: "commercial/IMR office",
      multiimages: [
        "img (1).webp",
        "img (2).webp",
        "img (3).webp",
        "img (4).webp",
        "img (5).webp",
        "img (6).webp",
        "img (7).webp",
        "img (8).webp",
        "img (9).webp",
        "img (10).webp",
        "img (11).webp",
        "img (12).webp",
        "img (13).webp"
      ]
    },
    {
      filename: "img (1).webp",
      title: "Shells, Customised Habitat",
      alt: "Shells, Customised Habitat",
      para: "Shells, Customised Habitat showcases innovative residential interior design in Coimbatore with personalized spaces, modern aesthetics, and sustainable layouts tailored for elegant and comfortable living",
      category: "residence",
      folder: "residence/shells",
      multiimages: [
        "img (1).webp",
        "img (2).webp",
        "img (3).webp",
        "img (4).webp",
        "img (5).webp",
        "img (6).webp",
        "img (7).webp",

      ]
    },
    {
      filename: "img (2).webp",
      title: "TAS it all (showroom)",
      alt: "TAS it all (showroom)",
      para: "TAS IT All showroom interiors reflect a bold retail interior design concept with premium displays, vibrant lighting, and a strategic layout that enhances customer experience and strengthens brand presence.",
      category: "commercial",
      folder: "commercial/TAS it all",
      multiimages: [
        "img (2).webp",
        "img (1).webp",
        "img (3).webp",
        "img (4).webp",
        "img (5).webp",
      ]
    },


    {
      filename: "img (1).webp",
      title: "Ticel Bio Park, Dlux Tech, Coimbatore",
      alt: "Ticel Bio Park, Dlux Tech, Coimbatore",
      para: "Ticel Bio Park interiors in Coimbatore blend advanced laboratory interior design with functional workspaces, creating a modern environment ideal for research, innovation, and productivity",
      category: "commercial",
      folder: "commercial/Ticel biopark",
      multiimages: [
        "img (1).webp",
        "img (2).webp",

      ]
    },
    {
      filename: "img (1).webp",
      title: "VMJ School",
      alt: "VMJ School",
      para: "VMJ School interiors are thoughtfully designed to inspire learning with vibrant classrooms, interactive spaces, and child-friendly layouts, making it a standout in school interior design in India.",
      category: "school",
      folder: "school/VMJ school",
      multiimages: [
        "img (1).webp",
        "img (2).webp",
        "img (3).webp",
      ]
    },

    {
      filename: "img (1).webp",
      title: "Mr.Vijay Residency, Madurai",
      alt: "Mr.Vijay Residency, Madurai",
      para: "Vijay Residency in Madurai presents elegant luxury residential interiors with high-end finishes, spacious layouts, and a perfect blend of comfort, sophistication, and modern living.",
      category: "residence",
      folder: "residence/vijay",
      multiimages: [
        "img (1).webp",
        "img (2).webp",
        "img (3).webp",
        "img (4).webp",
        "img (5).webp",
        "img (6).webp",
        "img (7).webp",
        "img (8).webp",
        "img (9).webp",
        "img (10).webp",
        "img (11).webp",
        "img (12).webp",
        "img (13).webp"
      ]
    },
    {
      filename: "img (1).webp",
      title: "MR. Wanstinman RES, Goundampalayam",
      alt: "MR. Wanstinman RES, Goundampalayam",
      para: "Proposed Interiors MR. Wanstinman RES Residence in Goundampalayam showcases personalized residential interior design in Coimbatore, featuring modern design elements, cozy spaces, and elegant finishes tailored for contemporary living.",
      category: "residence",
      folder: "residence/wanstinman",
      multiimages: [
        "img (1).webp",
        "img (2).webp",
        "img (3).webp",
      ]
    },

  ];

  const container = document.getElementById("dynamicGallery");

  imageData.forEach(({
    filename,
    title,
    alt,
    category,
    para,
    multiimages,
    folder
  }) => {
    const colDiv = document.createElement("div");
    colDiv.className = `col-lg-4 col-md-6 mb-4 gallery-item ${category}`;

    // Base folder path
    const basePath = `./assets/img/projects/interiors/${folder}/`;

    // Main image link
    let lightboxLinks = `
    <a href="${basePath}${multiimages[0]}" class="glightbox" data-gallery="${title}" data-title="${title}">
      <img class="img-fluid" src="${basePath}${filename}" alt="${alt}" loading="lazy">
      <div class="overlay-icon">
        <i class="bi bi-eye"></i>
      </div>
      <p class="image-caption-h2 text-center mt-2">${title}</p>
      <p class="image-caption text-center mt-2">${para}</p>
    </a>
  `;

    // Add remaining images to lightbox
    for (let i = 1; i < multiimages.length; i++) {
      lightboxLinks += `
      <a href="${basePath}${multiimages[i]}" class="glightbox d-none" data-gallery="${title}" data-title="${title}"></a>
    `;
    }

    colDiv.innerHTML = `
    <div class="image-box position-relative overflow-hidden">
      ${lightboxLinks}
    </div>
  `;

    container.appendChild(colDiv);
  });

  // Init GLightbox
  const lightbox = GLightbox({
    selector: '.glightbox',
    touchNavigation: true,
    loop: true,
    zoomable: false
  });
</script>


<script>
  const filterButtons = document.querySelectorAll('.project-filter li');

  filterButtons.forEach(btn => {
    btn.addEventListener('click', () => {
      const filter = btn.getAttribute('data-filter');

      // Update active class
      filterButtons.forEach(b => b.classList.remove('active'));
      btn.classList.add('active');

      // Filter images
      document.querySelectorAll('.gallery-item').forEach(item => {
        if (filter === 'all' || item.classList.contains(filter)) {
          item.style.display = "block";
        } else {
          item.style.display = "none";
        }
      });
    });
  });
</script>

</html>